/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.srvutil;

import com.ibm.hsc.auiml.databeans.sfp.srvutil.ServiceUtilConstants;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.SysAttnLEDBean;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.ccfw.mom.PILparImage;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PILEDDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hsc.websm.sfp.ServiceUtilitiesTarget;
import com.ibm.hsc.websm.sfp.srvutil.SysAttnLEDMsgText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class SysAttnLEDTasklet
extends TargetedTasklet
implements ServiceUtilConstants {
    private static final String TRACE_MASKD = "JSYSLEDD";
    private static final String TRACE_MASKF = "JSYSLEDF";
    private static final String TRACE_MASKT = "JSYSLEDT";
    private static final LocalizableText BUSY_TITLE = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TITLE_1");
    private static final LocalizableText BUSY_CONTENT = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_SYSTEM_TEXT");
    private static final LocalizableText BUSY_TITLE_1 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TITLE_2");
    private static final LocalizableText BUSY_CONTENT_1 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "LED_COMMAND_ISSUED");
    private static final LocalizableText CONFIRM_TITLE = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "SFP_MESSAGE_INFO_TITLE");
    private static final LocalizableText CONFIRM_DEACTIVATE = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "CONFIRM_SYSATTN_LED_OFF");
    private static final String LED_SYS_ATTN_MENU_CMD = "SysAttnLEDMenuSelected.DeactivateSysAttnLED";
    private static final String LED_PARTITION_MENU_CMD = "SysAttnLEDMenuPartition.DeactivatePartitionLED";
    private static final short ACTIVATE = 1;
    private static final short DEACTIVATE = 0;
    private static final short LED_SA_TYPE_PHYSICAL = 2;
    private static final short LED_SA_TYPE_VIRTUAL_SYS = 1;
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.srvutil.SysAttnLED";
    private static final String INITIAL_PANEL = "SysAttnLEDPanel";
    private static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    private static final short ERRID_0010 = 16;
    private static final short ERRID_0011 = 17;
    private static final short ERRID_0012 = 18;
    private static final short ERRID_0013 = 19;
    private static final short ERRID_0014 = 20;
    private static final short ERRID_0015 = 21;
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -128, "SFPUtilSALED");
    private Object refreshTargetObj = null;
    private PIHSCCECClient savedClient = null;

    public SysAttnLEDTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> SysAttnLEDTasklet c-tor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysAttnLEDTasklet.service()");
        SysAttnLEDBean sysAttnLEDBean = new SysAttnLEDBean();
        String string = null;
        String string2 = null;
        if (panelTaskletRequest.isInitialRequest()) {
            Object object;
            Trace.trace((String)TRACE_MASKF, (Object)"-> SysAttnLEDTasklet.isInitialRequest()");
            sysAttnLEDBean.setBeanName("SysAttnLEDBean");
            Target[] targetArray = this.getSelectedTargets();
            string = targetArray[0].getName().toString();
            this.refreshTargetObj = object = ((ServiceUtilitiesTarget)targetArray[0]).getTargetObject();
            if (object instanceof PICec) {
                string2 = ((PICec)object).getUserDefinedName();
                Trace.trace((String)TRACE_MASKF, (Object)("-- selected system name is: " + string));
                Trace.trace((String)TRACE_MASKF, (Object)("-- userDefinedName is: " + string2));
                if (string != null && string.length() != 0) {
                    sysAttnLEDBean.setSelectedSystem(string);
                }
                this.showBusyDialog(BUSY_TITLE, BUSY_CONTENT);
                try {
                    PIHSCCECClient pIHSCCECClient = this.createCECClient(string2);
                    sysAttnLEDBean.setWorkingLEDState(2);
                    this.getSysAttnLEDState(pIHSCCECClient, sysAttnLEDBean);
                    this.getPartitionLEDStates(pIHSCCECClient, object, sysAttnLEDBean);
                    this.destroyBusyDialog();
                    panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)sysAttnLEDBean);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("Unexpected exception in initial service request, e is " + exception));
                    this.destroyBusyDialog();
                    String string3 = exception instanceof UnknownHostException ? "0128" : (exception instanceof PIHscClientException ? "0126" : "0127");
                    SFPUtil.showSFPErrorMessageBox(string3, (PanelTasklet)this);
                    try {
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)sysAttnLEDBean);
                    }
                    catch (Exception exception2) {
                        Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during initial service request, e1 is " + exception2));
                        panelTaskletResponse.terminate();
                    }
                }
            } else {
                panelTaskletResponse.noAction();
            }
            Trace.trace((String)TRACE_MASKF, (Object)"<- SysAttnLEDTasklet.isInitialRequest()");
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)("taskletRequest.getData(event): " + panelTaskletRequest.getData("event") + "."));
            if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                Trace.trace((String)TRACE_MASKF, (Object)"taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
                panelTaskletResponse.dispose();
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Some taskletRequest other than Cancel is pending.");
                String string4 = (String)panelTaskletRequest.getData("event");
                SysAttnLEDBean sysAttnLEDBean2 = (SysAttnLEDBean)panelTaskletRequest.getData("DataBean");
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                Trace.trace((String)TRACE_MASKF, (Object)("event is " + string4));
                if (string4.equals("RefreshButton")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"Refresh button found tasklet side.");
                    this.showBusyDialog(BUSY_TITLE, BUSY_CONTENT);
                    try {
                        this.getSysAttnLEDState(this.savedClient, sysAttnLEDBean);
                        this.getPartitionLEDStates(this.savedClient, this.refreshTargetObj, sysAttnLEDBean);
                        this.destroyBusyDialog();
                        hashMap.put("DataBean", sysAttnLEDBean2);
                        hashMap.put("event", "RefreshButton");
                        panelTaskletResponse.update(sysAttnLEDBean2.getBeanName(), hashMap);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("Unexpected exception in service request, e is " + exception));
                        this.destroyBusyDialog();
                        String string5 = exception instanceof UnknownHostException ? "0128" : (exception instanceof PIHscClientException ? "0126" : "0127");
                        SFPUtil.showSFPErrorMessageBox(string5, (PanelTasklet)this);
                        panelTaskletResponse.noAction();
                    }
                } else if (string4.equals(LED_SYS_ATTN_MENU_CMD)) {
                    Trace.trace((String)TRACE_MASKF, (Object)"System SA LED menu event found tasklet side.");
                    boolean bl = false;
                    bl = this.showConfirmMessageBox();
                    if (bl) {
                        this.showBusyDialog(BUSY_TITLE_1, BUSY_CONTENT_1);
                        try {
                            this.setSysAttnLEDState((short)0, this.savedClient, sysAttnLEDBean2);
                            this.getSysAttnLEDState(this.savedClient, sysAttnLEDBean2);
                            this.destroyBusyDialog();
                            String string6 = "0222";
                            SFPUtil.showSFPInfoMessageBox(string6, (PanelTasklet)this);
                            hashMap.put("DataBean", sysAttnLEDBean2);
                            hashMap.put("event", "RefreshButton");
                            panelTaskletResponse.update(sysAttnLEDBean2.getBeanName(), hashMap);
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKF, (Object)("Unexpected exception in service request, e is " + exception));
                            this.destroyBusyDialog();
                            String string7 = exception instanceof UnknownHostException ? "0128" : (exception instanceof PIHscClientException ? "0126" : "0127");
                            SFPUtil.showSFPErrorMessageBox(string7, (PanelTasklet)this);
                            panelTaskletResponse.noAction();
                        }
                    } else {
                        panelTaskletResponse.noAction();
                    }
                } else if (string4.equals(LED_PARTITION_MENU_CMD)) {
                    Trace.trace((String)TRACE_MASKF, (Object)"Partition SA LED menu event found tasklet side.");
                    this.showBusyDialog(BUSY_TITLE_1, BUSY_CONTENT_1);
                    try {
                        this.setPartitionLEDStates((short)0, this.savedClient, this.refreshTargetObj, sysAttnLEDBean2);
                        this.getPartitionLEDStates(this.savedClient, this.refreshTargetObj, sysAttnLEDBean2);
                        this.destroyBusyDialog();
                        String string8 = "0223";
                        SFPUtil.showSFPInfoMessageBox(string8, (PanelTasklet)this);
                        hashMap.put("DataBean", sysAttnLEDBean2);
                        hashMap.put("event", "RefreshButton");
                        panelTaskletResponse.update(sysAttnLEDBean2.getBeanName(), hashMap);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("Unexpected exception in service request, e is " + exception));
                        this.destroyBusyDialog();
                        String string9 = exception instanceof UnknownHostException ? "0128" : (exception instanceof PIHscClientException ? "0126" : "0127");
                        SFPUtil.showSFPErrorMessageBox(string9, (PanelTasklet)this);
                        panelTaskletResponse.noAction();
                    }
                } else {
                    Trace.trace((String)TRACE_MASKT, (Object)"Unknown tasklet request sent to SysAttnLEDTasklet.");
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysAttnLEDTasklet.service()");
    }

    protected PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysAttnLEDTasklet.createCECClient()");
        Trace.trace((String)TRACE_MASKF, (Object)("-- input arg is <" + string + ">"));
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKF, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, false);
                if (null == pIHSCCECClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCCECClient - client is null");
                    throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "MANAGED_SYSTEM_NOT_FOUND", null, null);
                }
                this.savedClient = pIHSCCECClient;
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw exception;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- unable to determine HMC hostname, exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysAttnLEDTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    protected void getSysAttnLEDState(PIHSCCECClient pIHSCCECClient, SysAttnLEDBean sysAttnLEDBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysAttnLEDTasklet.getSysAttnLEDState()");
        PILEDDataBean pILEDDataBean = null;
        PILEDDataBean pILEDDataBean2 = null;
        try {
            pILEDDataBean = pIHSCCECClient.getSALEDInfo("phys");
            Trace.trace((String)TRACE_MASKF, (Object)"-- successful LED query using type=LED_SA_TYPE_PHYSICAL");
            Integer[] integerArray = pILEDDataBean.getLEDStates();
            Integer n = integerArray[0];
            pILEDDataBean2 = pIHSCCECClient.getSALEDInfo("virtualsys");
            Trace.trace((String)TRACE_MASKF, (Object)"-- successful LED query using type=LED_SA_TYPE_VIRTUAL_SYS");
            Integer[] integerArray2 = pILEDDataBean.getLEDStates();
            Integer n2 = integerArray2[0];
            Trace.trace((String)TRACE_MASKF, (Object)("-- pState is: " + n + ", vState is: " + n2));
            if (n == 2 || n2 == 2) {
                Trace.trace((String)TRACE_MASKF, (Object)"-- setting SA LED state to ON in the bean");
                sysAttnLEDBean.setWorkingLEDState(1);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"-- setting SA LED state to OFF in the bean");
                sysAttnLEDBean.setWorkingLEDState(0);
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking the getSALEDInfo() cmd. Exception is: " + exception));
            new AusMicrocodeLog(_logInfo, 17, exception).writeEntry(null);
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysAttnLEDTasklet.getSysAttnLEDState()");
    }

    protected void getPartitionLEDStates(PIHSCCECClient pIHSCCECClient, Object object, SysAttnLEDBean sysAttnLEDBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysAttnLEDTasklet.getPartitionLEDStates()");
        PILEDDataBean pILEDDataBean = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        try {
            Set set = ((PICec)object).getLparImages();
            String[] stringArray = new String[set.size()];
            int n = 0;
            Integer[] integerArray = set.iterator();
            while (integerArray.hasNext()) {
                PILparImage pILparImage = (PILparImage)integerArray.next();
                String string = pILparImage.getUserDefinedName();
                stringArray[n++] = string;
                arrayList.add(string);
                arrayList2.add(new String(pILparImage.getPartitionNumber()));
                Trace.trace((String)TRACE_MASKF, (Object)("-- index: " + n + ", partitionName: " + string + ", partition number: " + pILparImage.getPartitionNumber()));
            }
            if (stringArray.length != 0) {
                pILEDDataBean = pIHSCCECClient.getVirtualPartitionSALEDInfo(stringArray, false);
                integerArray = pILEDDataBean.getLEDStates();
                for (n = 0; n < integerArray.length; ++n) {
                    arrayList3.add(integerArray[n]);
                    Trace.trace((String)TRACE_MASKF, (Object)("-- partition[" + n + "] state is: " + integerArray[n]));
                }
            }
            sysAttnLEDBean.setPartitionNames(arrayList);
            sysAttnLEDBean.setPartitionNumbers(arrayList2);
            sysAttnLEDBean.setPartitionLEDStates(arrayList3);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking the getVirtualPartitionSALEDInfo() cmd. Exception is: " + exception));
            new AusMicrocodeLog(_logInfo, 18, exception).writeEntry(null);
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysAttnLEDTasklet.getPartitionLEDStates()");
    }

    protected void setSysAttnLEDState(short s, PIHSCCECClient pIHSCCECClient, SysAttnLEDBean sysAttnLEDBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysAttnLEDTasklet.setSysAttnLEDState()");
        try {
            pIHSCCECClient.setSALEDState((short)2, s);
            Trace.trace((String)TRACE_MASKF, (Object)"-- successful resetting the SA LED using type=LED_SA_TYPE_PHYSICAL");
            pIHSCCECClient.setSALEDState((short)1, s);
            Trace.trace((String)TRACE_MASKF, (Object)"-- successful resetting the SA LED using type=LED_SA_TYPE_VIRTUAL_SYS");
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking the setSALEDInfo() cmd. Exception is: " + exception));
            new AusMicrocodeLog(_logInfo, 19, exception).writeEntry(null);
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysAttnLEDTasklet.setSysAttnLEDState()");
    }

    protected void setPartitionLEDStates(short s, PIHSCCECClient pIHSCCECClient, Object object, SysAttnLEDBean sysAttnLEDBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysAttnLEDTasklet.setPartitionLEDStates()");
        Object var5_5 = null;
        ArrayList arrayList = null;
        try {
            arrayList = sysAttnLEDBean.getSelectedPartitionNumbers();
            if (arrayList != null && arrayList.size() != 0) {
                Integer[] integerArray = new Integer[arrayList.size()];
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                    integerArray[i] = new Integer(s);
                }
                pIHSCCECClient.setVirtualPartitionSALEDStates(stringArray, integerArray, true);
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking the setVirtualPartitionSALEDInfo() cmd. Exception is: " + exception));
            new AusMicrocodeLog(_logInfo, 20, exception).writeEntry(null);
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysAttnLEDTasklet.setPartitionLEDStates()");
    }

    private boolean showConfirmMessageBox() {
        boolean bl = false;
        LocalizableText localizableText = null;
        SysAttnLEDMsgText sysAttnLEDMsgText = new SysAttnLEDMsgText("SFPResourceBundle", "CONFIRM_SYSATTN_LED_OFF", null, MsgType.WARNING_MESSAGE);
        try {
            localizableText = this.showMessageBox(true, CONFIRM_TITLE, sysAttnLEDMsgText, MsgType.WARNING_MESSAGE, null);
            if (localizableText != null && localizableText.equals((Object)CommonMsgApp.OK_BUTTON)) {
                bl = true;
            }
        }
        catch (TaskletException taskletException) {
            Trace.trace((String)TRACE_MASKF, (Object)("TaskletException while showing confirm message box: " + (Object)((Object)taskletException)));
            new AusMicrocodeLog(_logInfo, 21, taskletException).writeEntry(null);
        }
        return bl;
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SysAttnLEDTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("processing exception: " + throwable));
        HException hException = new HException(throwable);
        new AusMicrocodeLog(_logInfo, 16, hException).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<- SysAttnLEDTasklet.logException()");
    }
}

